//=============================================================================
// AmmoShell.
//=============================================================================
class AmmoSMG extends DeusExAmmo;

#exec MESH IMPORT MESH=SMGAmmo ANIVFILE=MODELS\SMGAmmo_a.3d DATAFILE=MODELS\SMGAmmo_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SMGAmmo X=0 Y=0 Z=100 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=SMGAmmo SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SMGAmmo SEQ=SMGAmmo STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=SMGAmmo MESH=SMGAmmo
#exec MESHMAP SCALE MESHMAP=SMGAmmo X=0.01933655625 Y=0.01933655625 Z=0.01933655625

#exec TEXTURE IMPORT FILE="Textures\CBAGray.pcx"	NAME="SMGAGray"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBAGold.pcx"	NAME="SMGAGold"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBADGold.pcx"	NAME="SMGADGold"	GROUP="Icons" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=SMGAmmo NUM=0 TEXTURE=SMGAGray
#exec MESHMAP SETTEXTURE MESHMAP=SMGAmmo NUM=1 TEXTURE=SMGAGold
#exec MESHMAP SETTEXTURE MESHMAP=SMGAmmo NUM=2 TEXTURE=SMGADGold


function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
      if ((DeusExMPGame(Level.Game) != None) && (!DeusExMPGame(Level.Game).bSpawnEffects))
      {
         shell = None;
      }
      else
      {
         if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
            shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
         else
            shell = spawn(class'ShellCasing',,, Owner.Location + offset);
      }

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

defaultproperties
{
     bShowInfo=True
     AmmoAmount=32
     MaxAmmo=1536
     ItemName="SMG Rounds"
     ItemArticle="some"
     PickupViewMesh=LodMesh'SMGAmmo'
     Icon=Texture'DeusExUI.Icons.BeltIconAmmo762'
     largeIconWidth=0
     largeIconHeight=0
     Description=""
     beltDescription=""
     Mesh=LodMesh'SMGAmmo'
     CollisionRadius=5.300000
     CollisionHeight=1.000000
     DrawScale=0.450000
     PickupViewScale=0.450000
     bCollideActors=True
}
